; Listboxes.asm - demonstrates listbox child window controls
;
; Demonstrates both single and multiple select listboxes.
;
; Note that even though the top listbox is quite large it's
; still a single select listbox. Usually, the height of the
; window is set to around one character high.
;

%define _WINMESSAGES_
%include "Gaz\Win32\Include\Windows.inc"

[BITS 32]
[section .text]

ddglobal _gbl_hInstance

procglobal WinMain, hInstance, hPrevInstance, lpszCmdLine, nCmdShow
	ddlocal		_hwnd
	struclocal	_wndclass, WNDCLASSEX, _msg, MSG
	endlocals
	WinMainPrologue
	mov	eax, .hInstance
	mov	._gbl_hInstance, eax
	mov	esi, ._wndclass
	mov	edi, ._msg
	mov	[esi + WNDCLASSEX.cbSize], dword WNDCLASSEX_size
	mov	[esi + WNDCLASSEX.style], dword CS_HREDRAW | CS_VREDRAW
	mov	[esi + WNDCLASSEX.lpfnWndProc], dword _WndProc
	mov	[esi + WNDCLASSEX.cbClsExtra], dword 0
	mov	[esi + WNDCLASSEX.cbWndExtra], dword 0
	mov	eax, .hInstance
	mov	[esi + WNDCLASSEX.hInstance], eax
	sc LoadIcon, NULL, IDI_APPLICATION
	mov	[esi + WNDCLASSEX.hIcon], eax
	sc LoadCursor, NULL, IDC_ARROW
	mov	[esi + WNDCLASSEX.hCursor], eax
	sc GetStockObject, WHITE_BRUSH
	mov	[esi + WNDCLASSEX.hbrBackground], eax
	mov	[esi + WNDCLASSEX.lpszMenuName], dword NULL
	TEXTlocal szClassName, 'MyClass',0
	mov	[esi + WNDCLASSEX.lpszClassName], dword .szClassName
	sc RegisterClassEx, esi
	cmp	eax, TRUE
	je	near _WinMain_Fail
	TEXTlocal szWndCaption, 'Listbox child window controls',0
	sc CreateWindowEx, 0, .szClassName, .szWndCaption, WS_OVERLAPPEDWINDOW | WS_VISIBLE, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, .hInstance, NULL
	mov	._hwnd, eax
	sc ShowWindow, ._hwnd, .nCmdShow
	sc UpdateWindow, ._hwnd
_WinMain_Loop:
	sc GetMessage, ._msg, NULL, 0, 0
	cmp	eax, TRUE
	jne	_WinMain_Loop_End
	sc TranslateMessage, ._msg
	sc DispatchMessage, ._msg
	jmp	_WinMain_Loop
_WinMain_Loop_End:
	mov	eax, [edi + MSG.wParam]
	jmp	_WinMain_End
_WinMain_Fail:
	TEXTlocal szErrorMsg, 'Failed to register window class!',0
	sc MessageBox, NULL, .szErrorMsg, .szWndCaption, MB_ICONERROR
_WinMain_End:
	WinMainEpilogue
endproc
;
;-----------------------------------------------------------------------
;
proc _WndProc, hwnd, message, wParam, lParam
	ddlocal		_width, _height
	buffstatic	_hwndListboxes, 4*4
	bufflocal	_szBuffer, 256*CHARSIZE
	endlocals
	;
	CallbackPrologue
	;
	switch .message
		case WM_CREATE
			;
			; Create two child windows for each control. One window
			; will be for the actual control, and one will be for us to do
			; some output on.
			;
			; Listbox (standard, LBS_STANDARD = LBS_NOTIFY | LBS_SORT | WS_BORDER | WS_VSCROLL)
			;
			mov	esi, ._hwndListboxes
			sc CreateWindowEx, 0, _szClassNameListbox, _szClassNameListbox, WS_CHILDWINDOW | WS_VISIBLE | LBS_STANDARD, 0, 0, 0, 0, .hwnd, 1, ._gbl_hInstance, NULL
			mov	[esi], eax
			sc CreateWindowEx, 0, _szClassNameStatic, NULL, WS_CHILDWINDOW | WS_VISIBLE | SS_CENTER, 0, 0, 0, 0, .hwnd, 2, ._gbl_hInstance, NULL
			mov	[esi + 4], eax
			;
			; Listbox (multiple select)
			;
			sc CreateWindowEx, 0, _szClassNameListbox, _szClassNameListbox, WS_CHILDWINDOW | WS_VISIBLE | LBS_NOTIFY | LBS_MULTIPLESEL | LBS_DISABLENOSCROLL | WS_BORDER | WS_VSCROLL, 0, 0, 0, 0, .hwnd, 3, ._gbl_hInstance, NULL
			mov	[esi + 8], eax
			sc CreateWindowEx, 0, _szClassNameStatic, NULL, WS_CHILDWINDOW | WS_VISIBLE | SS_CENTER, 0, 0, 0, 0, .hwnd, 4, ._gbl_hInstance, NULL
			mov	[esi + 12], eax
			;
			; After creating the listboxes we need to populate the
			; listboxes with some data. We do this, like practically
			; everything else in Windows, by sending messages
			;
			; To add an item we send an LB_ADDSTRING message with
			; the lParam holding the address of the string to add.
			;
			; You could also send LB_INSERTSTRING to insert a string
			; at any position in the list (though this should only
			; be used if you _haven't_ used the LBS_SORT style)
			;
			; For this simple example, I create a set of strings
			; and add them to the two lists:
			;
			TEXTlocal _szLbItem1, 'Item 1',0
			TEXTlocal _szLbItem2, 'Item 2',0
			TEXTlocal _szLbItem3, 'Item 3',0
			TEXTlocal _szLbItem4, 'Item 4',0
			TEXTlocal _szLbItem5, 'Item 5',0
			TEXTlocal _szLbItem6, 'Item 6',0
			TEXTlocal _szLbItem7, 'Item 7',0
			TEXTlocal _szLbItem8, 'Item 8',0
			TEXTlocal _szLbItem9, 'Item 9',0
			TEXTlocal _szLbItem10, 'Item 10',0
			TEXTlocal _szLbItem11, 'Item 11',0
			TEXTlocal _szLbItem12, 'Item 12',0
			TEXTlocal _szLbItem13, 'Item 13',0
			TEXTlocal _szLbItem14, 'Item 14',0
			TEXTlocal _szLbItem15, 'Item 15',0
			TEXTlocal _szLbItem16, 'Item 16',0
			TEXTlocal _szLbItem17, 'Item 17',0
			TEXTlocal _szLbItem18, 'Item 18',0
			TEXTlocal _szLbItem19, 'Item 19',0
			TEXTlocal _szLbItem20, 'Item 20',0
			sc SendMessage, [esi], LB_ADDSTRING, 0, ._szLbItem1
			sc SendMessage, [esi + 8], LB_ADDSTRING, 0, ._szLbItem1
			sc SendMessage, [esi], LB_ADDSTRING, 0, ._szLbItem2
			sc SendMessage, [esi + 8], LB_ADDSTRING, 0, ._szLbItem2
			sc SendMessage, [esi], LB_ADDSTRING, 0, ._szLbItem3
			sc SendMessage, [esi + 8], LB_ADDSTRING, 0, ._szLbItem3
			sc SendMessage, [esi], LB_ADDSTRING, 0, ._szLbItem4
			sc SendMessage, [esi + 8], LB_ADDSTRING, 0, ._szLbItem4
			sc SendMessage, [esi], LB_ADDSTRING, 0, ._szLbItem5
			sc SendMessage, [esi + 8], LB_ADDSTRING, 0, ._szLbItem5
			sc SendMessage, [esi], LB_ADDSTRING, 0, ._szLbItem6
			sc SendMessage, [esi + 8], LB_ADDSTRING, 0, ._szLbItem6
			sc SendMessage, [esi], LB_ADDSTRING, 0, ._szLbItem7
			sc SendMessage, [esi + 8], LB_ADDSTRING, 0, ._szLbItem7
			sc SendMessage, [esi], LB_ADDSTRING, 0, ._szLbItem8
			sc SendMessage, [esi + 8], LB_ADDSTRING, 0, ._szLbItem8
			sc SendMessage, [esi], LB_ADDSTRING, 0, ._szLbItem9
			sc SendMessage, [esi + 8], LB_ADDSTRING, 0, ._szLbItem9
			sc SendMessage, [esi], LB_ADDSTRING, 0, ._szLbItem10
			sc SendMessage, [esi + 8], LB_ADDSTRING, 0, ._szLbItem10
			sc SendMessage, [esi], LB_ADDSTRING, 0, ._szLbItem11
			sc SendMessage, [esi + 8], LB_ADDSTRING, 0, ._szLbItem11
			sc SendMessage, [esi], LB_ADDSTRING, 0, ._szLbItem12
			sc SendMessage, [esi + 8], LB_ADDSTRING, 0, ._szLbItem12
			sc SendMessage, [esi], LB_ADDSTRING, 0, ._szLbItem13
			sc SendMessage, [esi + 8], LB_ADDSTRING, 0, ._szLbItem13
			sc SendMessage, [esi], LB_ADDSTRING, 0, ._szLbItem14
			sc SendMessage, [esi + 8], LB_ADDSTRING, 0, ._szLbItem14
			sc SendMessage, [esi], LB_ADDSTRING, 0, ._szLbItem15
			sc SendMessage, [esi + 8], LB_ADDSTRING, 0, ._szLbItem15
			sc SendMessage, [esi], LB_ADDSTRING, 0, ._szLbItem16
			sc SendMessage, [esi + 8], LB_ADDSTRING, 0, ._szLbItem16
			sc SendMessage, [esi], LB_ADDSTRING, 0, ._szLbItem17
			sc SendMessage, [esi + 8], LB_ADDSTRING, 0, ._szLbItem17
			sc SendMessage, [esi], LB_ADDSTRING, 0, ._szLbItem18
			sc SendMessage, [esi + 8], LB_ADDSTRING, 0, ._szLbItem18
			sc SendMessage, [esi], LB_ADDSTRING, 0, ._szLbItem19
			sc SendMessage, [esi + 8], LB_ADDSTRING, 0, ._szLbItem19
			sc SendMessage, [esi], LB_ADDSTRING, 0, ._szLbItem20
			sc SendMessage, [esi + 8], LB_ADDSTRING, 0, ._szLbItem20
			xor	eax, eax
			break
		case WM_COMMAND
			;
			; Obtain child window notification code in eax
			;
			mov	ebx, .wParam
			shr	ebx, 16
			movsx	eax, bx
			;
			; Get the child window handle in ebx
			;
			mov	ebx, .lParam
			switch ebx
				case [._hwndListboxes]
					;
					; Top listbox, has the selection changed?
					;
					if eax, e, LBN_SELCHANGE
						;
						; Yes, so update the static control. First we need to obtain which
						; item is currently selected. To do this we ask the list to return
						; the index of the item that's selected:
						;
						sc SendMessage, [._hwndListboxes], LB_GETCURSEL, 0, 0
						;
						; The value returned is a zero-based index into the list, unless
						; there's nothing selected, in which case it's LB_ERR so we
						; check for that case here. We'll use ebx to hold the address of
						; the string to display so in case it is LB_ERR we'll set it
						; first
						;
						TEXTlocal _szLbNoSelection, 'No selection',0
						mov	esi, ._szLbNoSelection
						if eax, ne, LB_ERR
							;
							; No error, so we use the index to copy the string to a buffer
							; via the LB_GETTEXT message with the last two parameters holding
							; the index of the item's text to retrieve and the address of the
							; buffer to store the data into, respectively.
							;
							mov	esi, ._szBuffer
							sc SendMessage, [._hwndListboxes], LB_GETTEXT, eax, esi
							;
							; The buffer must be large enough to hold the string (including
							; space for the null terminator). If you need to, you can send
							; a LB_GETTEXTLEN message to find out the length first.
							;
						endif
						sc SetWindowText, [._hwndListboxes + 4], esi
					endif
					break
				case [._hwndListboxes + 8]
					;
					; Bottom listbox, has the selection changed?
					;
					if eax, e, LBN_SELCHANGE
						;
						; Yes, so now we need to know which items are selected. To do
						; this we've got a number of options available. The technique
						; I'll demonstrate here is to loop through every item in the
						; list and checking whether it's selected or not. Another
						; way is to send a LB_GETSELITEMS message which will fill an
						; array with the indices of all the selected items.
						;
						; First we get the number of items in the list
						;
						sc SendMessage, [._hwndListboxes + 8], LB_GETCOUNT, 0, 0
						;
						; And store this in esi
						;
						mov	esi, eax
						;
						; We'll use edi to point to the buffer
						;
						mov	edi, ._szBuffer
						;
						; Now loop through each item in the list
						;
						for ebx, 0, ne, esi, 1
							;
							; Is this item selected?
							;
							sc SendMessage, [._hwndListboxes + 8], LB_GETSEL, ebx, 0
							if eax, ne, 0
								;
								; Yes, so add this to the buffer
								;
								sc SendMessage, [._hwndListboxes + 8], LB_GETTEXT, ebx, edi
								;
								; And move on in the buffer to after the length of the text
								;
								sc SendMessage, [._hwndListboxes + 8], LB_GETTEXTLEN, ebx, 0
								add	edi, eax
								;
								; Add in a separator for the next item
								;
								mov	[edi], byte ','
								mov	[edi + 1], byte ' '
								add 	edi, 2
							endif
						next
						;
						; Finally, add in the null-terminator and update the static text
						;
						mov	[edi], byte 0
						sc SetWindowText, [._hwndListboxes + 12], ._szBuffer
						sc SendMessage, [._hwndListboxes + 12], WM_PAINT, 0, 0
					endif
					break
			switchend
			xor	eax, eax
			break
		case WM_SIZE
			;
			; Resize the window - we obtain the window width and height in esi
			; and edi and then split it into 4 windows for the controls, with
			; two down and two across
			;
			mov	eax, .lParam
			movsx	esi, ax
			shr	eax, 16
			movsx	edi, ax
			;
			; Divide width by two
			;
			shr	esi, 1
			;
			; Divide height by two
			;
			shr	edi, 1
			;
			; Create the windows
			;
			mov	ebx, ._hwndListboxes
			sc MoveWindow, [ebx], 0, 0, esi, edi, TRUE
			sc MoveWindow, [ebx + 4], esi, 0, esi, edi, TRUE
			sc MoveWindow, [ebx + 8], 0, edi, esi, edi, TRUE
			sc MoveWindow, [ebx + 12], esi, edi, esi, edi, TRUE
			xor	eax, eax
			break
		case WM_DESTROY
			sc PostQuitMessage, 0
			xor	eax, eax
			break
		default
			sc DefWindowProc, .hwnd, .message, .wParam, .lParam
	switchend
	;
	CallbackEpilogue
endproc
;
;-----------------------------------------------------------------------
;
[section .bss]

[section .data]
